const nodemailer = require('nodemailer');
const mailConfig = require('../config/mailerConfig');

const transporter = nodemailer.createTransport({
    ...mailConfig.smtp,
    pool: true,
    maxConnections: 5,
    maxMessages: 10,
});

const sendMail = async (to, subject, text, html) => {
    const info = await transporter.sendMail({
        from: `"${mailConfig.senderName}" <${mailConfig.senderEmail}>`,
        to: to,
        subject: subject,
        text: text,
        html: html,
        headers: {
            "Content-Type": "text/html; charset=UTF-8" 
        }
    });

    if (mailConfig.debug) {
        console.log('Message sent: %s', info.messageId);
    }
    return info;
};

module.exports = { sendMail };
